package ru.yandex.chemodan.app.dataapi.apps.profile.address;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.api.deltas.FieldChange;
import ru.yandex.commune.a3.action.result.pojo.ActionResultPojo;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BendingMethod;
import ru.yandex.misc.bender.parse.BenderJsonNode;
import ru.yandex.misc.bender.parse.UnmarshallerContext;
import ru.yandex.misc.bender.parse.XmlOrJsonNode;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author tolmalev
 */
@BenderBindAllFields
@ActionResultPojo
public class AddressPatch extends DefaultObject {

    public final ListF<FieldChange> fieldChanges;

    public AddressPatch(ListF<FieldChange> fieldChanges) {
        this.fieldChanges = fieldChanges;
    }

    @BendingMethod
    public static AddressPatch parse(XmlOrJsonNode node, UnmarshallerContext context) {
        if (node.isJson()) {
            BenderJsonNode json = node.getJson();
            ListF<FieldChange> fieldChanges = Cf.<FieldChange>list()
                    .plus(setStringField(Address.TITLE, json))
                    .plus(setDoubleField(Address.LATITUDE, json))
                    .plus(setDoubleField(Address.LONGITUDE, json))
                    .plus(setStringField(Address.ADDRESS_LINE, json))
                    .plus(setStringField(Address.ADDRESS_LINE_SHORT, json))
                    .plus(setTimestampField(Address.LAST_USED, json))
                    .plus(setListField(Address.TAGS, json))
                    .plus(setStringField(Address.ENTRANCE_NUMBER, json))
                    .plus(setStringField(Address.CUSTOM_METADATA, json));

            return new AddressPatch(fieldChanges);
        } else {
            throw new IllegalArgumentException("xml not supported");
        }
    }


    private static Option<FieldChange> setStringField(String key, BenderJsonNode json) {
        return json.getField(key).map((f) -> f.isNull()
                ? FieldChange.delete(key)
                : FieldChange.put(key, DataField.string(f.getValueAsString())));
    }

    private static Option<FieldChange> setDoubleField(String key, BenderJsonNode json) {
        return json.getField(key).map((f) -> f.isNull()
                ? FieldChange.delete(key)
                : FieldChange.put(key, DataField.decimal(f.getNumberValueOrNull().doubleValue())));
    }

    private static Option<FieldChange> setTimestampField(String key, BenderJsonNode json) {
        return json.getField(key).map((f) -> f.isNull()
                ? FieldChange.delete(key)
                : FieldChange
                    .put(key, DataField.timestamp(new Instant(f.getNumberValueOrNull().longValue()))));
    }

    private static Option<FieldChange> setListField(String key, BenderJsonNode json) {
        return json.getField(key).map((f) -> f.isNull()
                ? FieldChange.delete(key)
                : FieldChange.put(key, DataField.list(f.getArrayElements().map(
                        (node) -> DataField.string(node.getValueAsString())).cast(DataField.class))));
    }
}
