package ru.yandex.chemodan.app.dataapi.apps.profile.address;

import org.joda.time.Instant;
import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecordId;
import ru.yandex.chemodan.app.dataapi.api.db.ref.AppDatabaseRef;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiPassportUserId;
import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.BenderParserSerializer;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.bender.config.CustomMarshallerUnmarshallerFactoryBuilder;
import ru.yandex.misc.bender.custom.InstantAsMillisMarshaller;
import ru.yandex.misc.bender.custom.InstantAsMillisUnmarshaller;
import ru.yandex.misc.geo.Coordinates;
import ru.yandex.misc.test.Assert;

/**
 * @author tolmalev
 */
public class AddressTest {

    private static final BenderParserSerializer<Address> PS = Bender.cons(Address.class, new BenderConfiguration(
            BenderConfiguration.defaultSettings(),
            CustomMarshallerUnmarshallerFactoryBuilder
                    .cons()
                    .add(Instant.class, new InstantAsMillisMarshaller())
                    .add(Instant.class, new InstantAsMillisUnmarshaller())
                    .build())
    );

    @Test
    public void complex() {
        DataRecord source = new DataRecord(
                new DataApiPassportUserId(1),
                new DataRecordId(new AppDatabaseRef("app", "dbId").consHandle("test"), "", "home"),
                1,
                sampleAddressData()
        );

        Assert.equals(
                source.getData(),
                PS.getParser().parseJson(
                        PS.getSerializer().serializeJson(Address.fromDataRecord(source))
                ).toDataMap()
        );
    }

    public static MapF<String, DataField> sampleAddressData() {
        return Cf
                .map(Address.LONGITUDE, DataField.decimal(1))
                .plus1(Address.LATITUDE, DataField.decimal(2))
                .plus1(Address.TITLE, DataField.string("Дом"))
                .plus1("address_line",
                        DataField.string("Россия, Санкт-Петербург, Колпино, Тверская улица, 6"))
                .plus1("address_line_short", DataField.string("Тверская улица, 6"))
                .plus1("created", DataField.timestamp(new Instant(100000)))
                .plus1("modified", DataField.timestamp(new Instant(100001)))
                .plus1("last_used", DataField.timestamp(new Instant(100002)))
                .plus1("tags",
                        DataField.list(Cf.list(DataField.string("home"), DataField.string("work"))))
                .plus1("mined_attributes", DataField.list(Cf.list(
                        DataField.string("address_line"),
                        DataField.string("address_line_short"))));
    }

    public static Address sampleAddress() {
        return new Address(
                Option.empty(),
                "Дом",
                new Coordinates(2, 1),
                Option.of("Россия, Санкт-Петербург, Колпино, Тверская улица, 6"),
                Option.of("Тверская улица, 6"),
                Option.of(new Instant(100000)),
                Option.of(new Instant(100001)),
                Option.of(new Instant(100002)),
                Cf.list("home", "work"),
                Cf.list("address_line", "address_line_short"),
                Option.empty(),
                Option.empty()
        );
    }
}
