package ru.yandex.chemodan.app.dataapi.apps.profile.address;

import java.util.Optional;

import yandex.maps.proto.common2.response.ResponseOuterClass;
import yandex.maps.proto.search.geocoder.Geocoder;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.inside.geosearch.GeosearchClient;
import ru.yandex.misc.geo.Coordinates;

/**
 * @author Denis Bakharev
 */
public class GeocoderHelper {
    private final GeosearchClient geosearchClient;

    public GeocoderHelper(GeosearchClient geosearchClient) {
        this.geosearchClient = geosearchClient;
    }

    public Option<AddressLines> findAddressLines(Coordinates coordinates) {
        ResponseOuterClass.Response geosearchResponse =
                geosearchClient.geocode(coordinates, "ru", Option.of(1), Option.empty(), Option.empty());

        return Cf.x(geosearchResponse.getReply().getGeoObjectList()).firstO().flatMapO(geoObject -> {
            Optional<Geocoder.GeoObjectMetadata> meta = GeosearchClient.extractGeoObjectMetadata(geoObject);
            return Option.of(new AddressLines(
                    meta.get().getAddress().getFormattedAddress(),
                    geoObject.getName()
            ));
        });
    }
}
