package ru.yandex.chemodan.app.dataapi.apps.profile.address;

import org.junit.Test;

import ru.yandex.bolts.collection.Option;
import ru.yandex.devtools.test.annotations.YaExternal;
import ru.yandex.inside.geosearch.GeosearchClient;
import ru.yandex.misc.geo.Coordinates;
import ru.yandex.misc.io.http.Timeout;
import ru.yandex.misc.io.http.apache.v4.ApacheHttpClientUtils;
import ru.yandex.misc.test.Assert;

/**
 * @author Denis Bakharev
 */
public class GeocoderHelperTest {
    @Test
    @YaExternal
    public void findAddressLines() {
        GeosearchClient geosearchClient = new GeosearchClient(GeosearchClient.TESTING_URL, "tests",
                ApacheHttpClientUtils.singleConnectionClient(Timeout.seconds(5)));

        GeocoderHelper geocoderHelper = new GeocoderHelper(geosearchClient);
        Option<AddressLines> addressLinesO = geocoderHelper.findAddressLines(new Coordinates(55.75438, 37.621462));

        Assert.isTrue(addressLinesO.get().getAddressLine().startsWith("Россия, Москва, "));
        Assert.isTrue(addressLinesO.get().getAddressLine().endsWith(", Красная площадь, 3"));
        Assert.equals("Красная площадь, 3", addressLinesO.get().getAddressLineShort());
    }
}
