package ru.yandex.chemodan.app.dataapi.apps.profile.address;

import org.joda.time.Duration;

import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.worker.DataApiTaskQueueName;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author Denis Bakharev
 */
public class SetAddressLinesFromGeocoderTask extends OnetimeTaskSupport<SetAddressLinesFromGeocoderTask.Parameters> {

    private AddressManager addressesManager;

    public SetAddressLinesFromGeocoderTask(DataApiUserId uid, long recordRevision, String addressRecordId) {
        super(new Parameters(uid, recordRevision, addressRecordId));
    }

    public SetAddressLinesFromGeocoderTask(AddressManager addressesManager) {
        super(Parameters.class);
        this.addressesManager = addressesManager;
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(1);
    }

    @Override
    protected void execute(Parameters parameters, ExecutionContext context) throws Exception {
        addressesManager.setAddressLinesFromGeocoder(parameters.uid,
                                                     parameters.addressRecordId,
                                                     parameters.recordRevision);
    }

    @Override
    public TaskQueueName queueName() {
        return DataApiTaskQueueName.DATAAPI_REGULAR;
    }

    @BenderBindAllFields
    public static final class Parameters {
        public final long recordRevision;
        public final String addressRecordId;
        public final DataApiUserId uid;

        Parameters(DataApiUserId uid, long recordRevision, String addressRecordId) {
            this.uid = uid;
            this.recordRevision = recordRevision;
            this.addressRecordId = addressRecordId;
        }
    }
}
