package ru.yandex.chemodan.app.dataapi.apps.profile.cache;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.apps.profile.full.FullProfileManager;
import ru.yandex.chemodan.app.dataapi.apps.profile.full.FullUserProfile;

/**
 * @author tolmalev
 */
public abstract class FullProfileCacheBase implements FullProfileCache {

    private final FullProfileManager fullProfileManager;

    public FullProfileCacheBase(FullProfileManager fullProfileManager) {
        this.fullProfileManager = fullProfileManager;
    }

    public FullUserProfile getProfile(DataApiUserId uid) {
        Option<FullUserProfile> inCache = findInCache(uid);
        if (inCache.isPresent()) {
            return inCache.get();
        }
        FullUserProfile result = fullProfileManager.getProfile(uid);
        saveToCache(uid, result);
        return result;
    }

    public abstract Option<FullUserProfile> findInCache(DataApiUserId uid);

    public abstract void saveToCache(DataApiUserId uid, FullUserProfile result);
}
