package ru.yandex.chemodan.app.dataapi.apps.profile.cache;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.apps.profile.full.FullUserProfile;
import ru.yandex.misc.cache.OsCacheAdapter;

/**
 * @author tolmalev
 */
public class InMemoryFullProfileCache implements FullProfileCache {

    private final OsCacheAdapter<FullUserProfile> cache = new OsCacheAdapter<>();

    public InMemoryFullProfileCache() {
        cache.setRefreshPeriodSeconds(3600);
    }

    @Override
    public Option<FullUserProfile> getFromCache(DataApiUserId uid) {
        return Option.x(cache.getFromCache(uid.toString()));
    }

    @Override
    public void putInCacheAsync(DataApiUserId uid, FullUserProfile profile) {
        cache.putInCache(uid.toString(), profile);
    }

    @Override
    public void invalidateForUserAsync(DataApiUserId uid) {
        cache.removeFromCache(uid.toString());
    }
}
