package ru.yandex.chemodan.app.dataapi.apps.profile.events;

import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.commune.bazinga.BazingaTaskManager;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author Denis Bakharev
 */
public class AsyncEventRemover {
    private static final Logger logger = LoggerFactory.getLogger(AsyncEventRemover.class);
    private final BazingaTaskManager bazingaTaskManager;

    public AsyncEventRemover(BazingaTaskManager bazingaTaskManager) {
        this.bazingaTaskManager = bazingaTaskManager;
    }

    public void scheduleEventRemoving(DataApiUserId uid, String recordId, Event event) {
        logger.info("Scheduling removing event {}, at {}", event, event.getEvictionTime());
        bazingaTaskManager
                .schedule(new RemoveOutdatedEventTask(uid, event.getEventType(), recordId), event.getEvictionTime());
    }
}
