package ru.yandex.chemodan.app.dataapi.apps.profile.events;

import ru.yandex.chemodan.app.dataapi.api.OneCollectionChangesAsyncHandlerSupport;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.chemodan.app.dataapi.api.deltas.DatabaseChange;

/**
 * @author tolmalev
 */
public class EventCollectionChangedAsyncHandler extends OneCollectionChangesAsyncHandlerSupport {

    private final AsyncEventRemover asyncEventRemover;
    private final EventType eventType;

    public EventCollectionChangedAsyncHandler(AsyncEventRemover asyncEventRemover, EventType eventType) {
        super(eventType.colRef);
        this.asyncEventRemover = asyncEventRemover;
        this.eventType = eventType;
    }

    @Override
    protected void collectionChanged(DatabaseChange change) {
        for (DataRecord record : change.getPatchedRecords()) {
            Event event = eventType.parse(record);
            asyncEventRemover.scheduleEventRemoving(record.uid, record.getRecordId(), event);
        }
    }
}
