package ru.yandex.chemodan.app.dataapi.apps.profile.events;

import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.app.dataapi.api.data.record.CollectionRef;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.chemodan.app.dataapi.apps.profile.ProfileUtils;
import ru.yandex.chemodan.app.dataapi.apps.profile.events.flights.Flight;

/**
 * @author tolmalev
 */
public enum  EventType {
    FLIGHT(ProfileUtils.FLIGHTS_COL_REF, Flight::fromDataRecord),
    ;

    public final CollectionRef colRef;
    private final Function<DataRecord, Event> parseF;

    EventType(CollectionRef colRef, Function<DataRecord, Event> parseF) {
        this.colRef = colRef;
        this.parseF = parseF;
    }

    public Event parse(DataRecord dataRecord) {
        return parseF.apply(dataRecord);
    }
}
