package ru.yandex.chemodan.app.dataapi.apps.profile.events;

import org.joda.time.Duration;

import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.worker.DataApiTaskQueueName;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author tolmalev
 */
public class RemoveOutdatedEventTask extends OnetimeTaskSupport<RemoveOutdatedEventTask.Parameters> {
    private static final Logger logger = LoggerFactory.getLogger(RemoveOutdatedEventTask.class);

    private final ActualEventsManager actualEventsManager;

    public RemoveOutdatedEventTask(DataApiUserId uid, EventType eventType, String recordId) {
        this(new Parameters(uid, eventType, recordId));
    }

    public RemoveOutdatedEventTask(Parameters parameters) {
        super(parameters);
        this.actualEventsManager = null;
    }

    public RemoveOutdatedEventTask(ActualEventsManager actualEventsManager) {
        super(Parameters.class);
        this.actualEventsManager = actualEventsManager;
    }

    @Override
    protected void execute(Parameters parameters, ExecutionContext context) throws Exception {
        actualEventsManager.removeOutdatedEvent(parameters.uid, parameters.eventType, parameters.recordId);
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(5);
    }

    @Override
    public TaskQueueName queueName() {
        return DataApiTaskQueueName.DATAAPI_REGULAR;
    }

    @BenderBindAllFields
    public static final class Parameters {
        public final DataApiUserId uid;
        public final EventType eventType;
        public final String recordId;

        Parameters(DataApiUserId uid, EventType eventType, String recordId) {
            this.uid = uid;
            this.eventType = eventType;
            this.recordId = recordId;
        }
    }
}
