package ru.yandex.chemodan.app.dataapi.apps.profile.events.flights;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.apps.profile.ProfileRecordSupport;
import ru.yandex.commune.protobuf5.annotation.ProtoField;
import ru.yandex.commune.protobuf5.annotation.ProtoMessage;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;

/**
 * @author tolmalev
 */
@Bendable
@ProtoMessage
public class Airline extends ProfileRecordSupport {

    public static final Airline EMPTY = new Airline(Option.empty(), Option.empty(),
            Option.empty(), Option.empty(), Option.empty());

    public static final String IATA_CODE = "iata_code";
    public static final String ICAO_CODE = "icao_code";
    public static final String SIRENA_CODE = "sirena_code";
    public static final String YA_SCHEDULE_ID = "ya_schedule_id";
    public static final String NAME = "name";

    @BenderPart(name = IATA_CODE, strictName = true)
    @ProtoField(n = 1)
    public final Option<String> iataCode;
    @BenderPart(name = ICAO_CODE, strictName = true)
    @ProtoField(n = 2)
    public final Option<String> icaoCode;
    @BenderPart(name = SIRENA_CODE, strictName = true)
    @ProtoField(n = 3)
    public final Option<String> sirenaCode;
    @BenderPart(name = YA_SCHEDULE_ID, strictName = true)
    @ProtoField(n = 4)
    public final Option<String> yaScheduleId;
    @BenderPart(name = NAME, strictName = true)
    @ProtoField(n = 5)
    public final Option<String> name;

    public Airline(Option<String> iataCode, Option<String> icaoCode, Option<String> sirenaCode,
            Option<String> yaScheduleId, Option<String> name)
    {
        this.iataCode = iataCode;
        this.icaoCode = icaoCode;
        this.sirenaCode = sirenaCode;
        this.yaScheduleId = yaScheduleId;
        this.name = name;
    }

    public static Option<Airline> parse(String prefix, MapF<String, DataField> data) {
        return parse(
                data.getO(prefix + IATA_CODE),
                data.getO(prefix + ICAO_CODE),
                data.getO(prefix + SIRENA_CODE),
                data.getO(prefix + YA_SCHEDULE_ID),
                data.getO(prefix + NAME)
        );
    }

    public static Option<Airline> parse(Option<DataField> iataCode, Option<DataField> icaoCode,
            Option<DataField> sirenaCode, Option<DataField> yaScheduleId, Option<DataField> name)
    {
        if (iataCode.size() + icaoCode.size() + sirenaCode.size() + yaScheduleId.size() + name.size() == 0) {
            return Option.empty();
        }
        return Option.of(new Airline(
                iataCode.map(DataField::stringValue),
                icaoCode.map(DataField::stringValue),
                sirenaCode.map(DataField::stringValue),
                yaScheduleId.map(DataField::stringValue),
                name.map(DataField::stringValue)
        ));
    }

    @Override
    public MapF<String, DataField> toDataMap() {
        MapF<String, DataField> result = Cf.map();
        result = plusStringO(result, IATA_CODE, iataCode);
        result = plusStringO(result, ICAO_CODE, icaoCode);
        result = plusStringO(result, SIRENA_CODE, sirenaCode);
        result = plusStringO(result, YA_SCHEDULE_ID, yaScheduleId);
        result = plusStringO(result, NAME, name);
        return result;
    }
}
