package ru.yandex.chemodan.app.dataapi.apps.profile.events.flights;

import org.joda.time.Instant;
import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecordId;
import ru.yandex.chemodan.app.dataapi.api.db.ref.AppDatabaseRef;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiPassportUserId;
import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.BenderParserSerializer;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.bender.config.CustomMarshallerUnmarshallerFactoryBuilder;
import ru.yandex.misc.bender.custom.InstantAsMillisMarshaller;
import ru.yandex.misc.bender.custom.InstantAsMillisUnmarshaller;
import ru.yandex.misc.test.Assert;

/**
 * @author tolmalev
 */
public class FlightTest {

    private static final BenderParserSerializer<Flight> PS = Bender.cons(Flight.class, new BenderConfiguration(
            BenderConfiguration.defaultSettings(),
            CustomMarshallerUnmarshallerFactoryBuilder
                    .cons()
                    .add(Instant.class, new InstantAsMillisMarshaller())
                    .add(Instant.class, new InstantAsMillisUnmarshaller())
                    .build())
    );

    @Test
    public void complex() {
        DataRecordId id = new DataRecordId(new AppDatabaseRef("app", "dbId").consHandle("test"), "", "flight1");
        DataRecord source = new DataRecord(new DataApiPassportUserId(1), id, 1, Cf
                        .map(Flight.FLIGHT_NUMBER, DataField.string("SU2030"))
                        .plus1(Flight.CHECKIN_URL, DataField.string("checkin_url"))
                        .plus1(Flight.DATA_SOURCE, DataField.string("mail"))

                        .plus1(Flight.AIRLINE_PREFIX + Airline.IATA_CODE, DataField.string("S7"))
                        .plus1(Flight.AIRLINE_PREFIX + Airline.YA_SCHEDULE_ID, DataField.string("124124"))
                        .plus1(Flight.AIRLINE_PREFIX + Airline.NAME, DataField.string("S7 Airlines"))

                        .plus1(Flight.DEPARTURE_PREFIX + FlightPlace.TIME, DataField.timestamp(Instant.now()))
                        .plus1(Flight.DEPARTURE_PREFIX + FlightPlace.TZ_OFFSET, DataField.integer(4 * 3600))
                        .plus1(Flight.DEPARTURE_PREFIX + FlightPlace.GEO_ID, DataField.integer(213))

                        .plus1(Flight.DEPARTURE_PREFIX + FlightPlace.AIRPORT_PREFIX + Airport.IATA_CODE,
                                DataField.string("SVO"))
                        .plus1(Flight.DEPARTURE_PREFIX + FlightPlace.AIRPORT_PREFIX + Airport.ICAO_CODE,
                                DataField.string("SVO-IC"))
                        .plus1(Flight.DEPARTURE_PREFIX + FlightPlace.AIRPORT_PREFIX + Airport.SIRENA_CODE,
                                DataField.string("SVO-SI"))
                        .plus1(Flight.DEPARTURE_PREFIX + FlightPlace.AIRPORT_PREFIX + Airport.YA_SCHEDULE_ID,
                                DataField.string("9600213"))
                        .plus1(Flight.DEPARTURE_PREFIX + FlightPlace.AIRPORT_PREFIX + Airport.NAME,
                                DataField.string("Шереметьево"))


                        .plus1(Flight.ARRIVAL_PREFIX + FlightPlace.TIME, DataField.timestamp(Instant.now()))
                        .plus1(Flight.ARRIVAL_PREFIX + FlightPlace.TZ_OFFSET, DataField.integer(2 * 3600))
                        .plus1(Flight.ARRIVAL_PREFIX + FlightPlace.CITY_NAME, DataField.string("Москва"))

                        .plus1(Flight.ARRIVAL_PREFIX + FlightPlace.AIRPORT_PREFIX + Airport.IATA_CODE,
                                DataField.string("SVO"))
                        .plus1(Flight.ARRIVAL_PREFIX + FlightPlace.AIRPORT_PREFIX + Airport.NAME,
                                DataField.string("Шереметьево")));

        Assert.equals(source.getData(), PS.getParser().parseJson(
                PS.getSerializer().serializeJson(Flight.fromDataRecord(source))
        ).toDataMap());

        Assert.equals(source.getData(), Flight.fromDataRecord(source).toDataMap());

        Flight flight = ProfileFlightsManagerTest.sampleFlight();
        Flight parsed = Flight.fromData("123", flight.toDataMap());
        Assert.equals(flight.withId("123"), parsed);
    }

}
