package ru.yandex.chemodan.app.dataapi.apps.profile.events.flights;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.chemodan.app.dataapi.api.data.record.RecordIdGenerator;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.apps.profile.GenericProfileNamespaceManagerBase;
import ru.yandex.chemodan.app.dataapi.apps.profile.ProfileUtils;
import ru.yandex.chemodan.app.dataapi.apps.profile.full.ActualEvents;
import ru.yandex.chemodan.app.dataapi.apps.profile.full.FullUserProfileBuilder;
import ru.yandex.chemodan.app.dataapi.core.datasources.disk.DiskDataSource;
import ru.yandex.chemodan.app.dataapi.core.manager.DataApiManager;

/**
 * @author tolmalev
 */
public class ProfileFlightsManager extends GenericProfileNamespaceManagerBase<Flight> {
    public ProfileFlightsManager(DataApiManager dataApiManager, DiskDataSource diskDataSource) {
        super(dataApiManager, diskDataSource, ProfileUtils.FLIGHTS_COL_REF, Flight::fromDataRecord);
    }

    public Flight createFlight(DataApiUserId uid, Flight flight) {
        return saveFlight(uid, RecordIdGenerator.generateId(), flight);
    }

    public Flight saveFlight(DataApiUserId uid, String eventId, Flight flight) {
        flight = flight.withId(eventId);
        setEntity(uid, flight);
        return flight;
    }

    @Override
    public void parse(FullUserProfileBuilder builder, ListF<DataRecord> records) {
        builder.setEvents(new ActualEvents(parseRecords(records)));
    }
}
