package ru.yandex.chemodan.app.dataapi.apps.profile.events.flights;

import org.joda.time.Instant;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.core.dao.test.ActivateDataApiEmbeddedPg;
import ru.yandex.chemodan.app.dataapi.test.DataApiTestSupport;
import ru.yandex.misc.test.Assert;

/**
 * @author tolmalev
 */
@ActivateDataApiEmbeddedPg
public class ProfileFlightsManagerTest extends DataApiTestSupport {

    @Autowired
    private ProfileFlightsManager flightsManager;

    @Test
    public void complex() {
        DataApiUserId uid = createRandomCleanUser();
        Assert.isEmpty(flightsManager.getEntitiesByUid(uid));

        Flight flight = sampleFlight();

        flightsManager.saveFlight(uid, "flight-1", flight);
        Assert.equals(flight.withId("flight-1"), flightsManager.getEntityByUidAndId(uid, "flight-1"));
        Assert.equals(Cf.list(flight.withId("flight-1")), flightsManager.getEntitiesByUid(uid));

        flight = new Flight(
                "SU2030",
                Option.empty(),
                Option.of(new Airline(
                        Option.of("S7-----"),
                        Option.empty(),
                        Option.empty(),
                        Option.empty(),
                        Option.of("S7 Airlines")
                )),
                new FlightPlace(
                        Option.of(Instant.now()),
                        Option.of(4 * 60 * 60),
                        Option.of(213),
                        Option.of(new Airport(
                                Option.of("SVO"),
                                Option.of("SVO"),
                                Option.of("SVO"),
                                Option.of("Шереметьево"),
                                Option.of("9600213")
                        )),
                        Option.empty()),
                Option.of(new FlightPlace(
                        Option.of(Instant.now()),
                        Option.of(4 * 60 * 60),
                        Option.empty(),
                        Option.of(new Airport(
                                Option.of("SVO"),
                                Option.of("SVO"),
                                Option.of("SVO"),
                                Option.of("Шереметьево"),
                                Option.of("9600213")
                        )),
                        Option.of("Москва"))),
                Option.of("mail"));

        flightsManager.saveFlight(uid, "flight-1", flight);
        Assert.equals(flight.withId("flight-1"), flightsManager.getEntityByUidAndId(uid, "flight-1"));
        Assert.equals(Cf.list(flight.withId("flight-1")), flightsManager.getEntitiesByUid(uid));

        flightsManager.deleteEntity(uid, "flight-1");
        Assert.none(flightsManager.getEntityByUidAndIdO(uid, "flight-1"));
        Assert.isEmpty(flightsManager.getEntitiesByUid(uid));
    }

    public static Flight sampleFlight() {
        return new Flight(
                "SU2030",
                Option.of("http://www.aeroflot.ru/cms/online_registration"),
                Option.of(new Airline(
                        Option.of("S7"),
                        Option.empty(),
                        Option.empty(),
                        Option.empty(),
                        Option.of("S7 Airlines")
                )),
                new FlightPlace(
                        Option.of(Instant.now()),
                        Option.of(4 * 60 * 60),
                        Option.empty(),
                        Option.of(new Airport(
                                Option.of("SVO"),
                                Option.of("SVO"),
                                Option.of("SVO"),
                                Option.of("Шереметьево"),
                                Option.of("9600213")
                        )),
                        Option.of("Москва")),
                Option.empty(),
                Option.of("mail"));
    }
}
