package ru.yandex.chemodan.app.dataapi.apps.profile.full;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.apps.profile.cache.FullProfileCache;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.misc.monica.annotation.GroupByDefault;
import ru.yandex.misc.monica.annotation.MonicaContainer;
import ru.yandex.misc.monica.annotation.MonicaMetric;
import ru.yandex.misc.monica.core.blocks.Instrument;
import ru.yandex.misc.monica.core.blocks.Meter;
import ru.yandex.misc.monica.core.name.MetricGroupName;
import ru.yandex.misc.monica.core.name.MetricName;

/**
 * @author tolmalev
 */
public class CachedFullProfileManager implements MonicaContainer {

    private final FullProfileManager target;
    private final FullProfileCache cache;

    private final DynamicProperty<Boolean> useCache = new DynamicProperty<>("use-profiles-cache", true);

    @GroupByDefault
    @MonicaMetric
    private final Meter profileCacheHit = new Meter();
    @GroupByDefault
    @MonicaMetric
    private final Meter profileCacheMiss = new Meter();
    @GroupByDefault
    @MonicaMetric
    private final Instrument profileCacheQuery = new Instrument();

    public CachedFullProfileManager(FullProfileManager target, FullProfileCache cache) {
        this.target = target;
        this.cache = cache;
    }

    public FullUserProfile getProfileNoCache(DataApiUserId uid) {
        FullUserProfile profile = target.getProfile(uid);
        if (useCache.get()) {
            cache.putInCacheAsync(uid, profile);
        }
        return profile;
    }

    public FullUserProfile getProfile(DataApiUserId uid) {
        if (useCache.get()) {
            Option<FullUserProfile> fromCache = profileCacheQuery.measure(() -> cache.getFromCache(uid));
            if (fromCache.isPresent()) {
                profileCacheHit.inc();
                return fromCache.get();
            }
            profileCacheMiss.inc();
        }

        return getProfileNoCache(uid);
    }

    @Override
    public MetricGroupName groupName(String instanceName) {
        return new MetricGroupName(
                "cache-profile-manager",
                new MetricName("dataapi", "profile", "cache"),
                "Cached profile manager");
    }
}
