package ru.yandex.chemodan.app.dataapi.apps.profile.full;

import ru.yandex.chemodan.app.dataapi.api.DatabaseChangedEventAsyncHandler;
import ru.yandex.chemodan.app.dataapi.api.deltas.DatabaseChange;
import ru.yandex.chemodan.app.dataapi.apps.profile.ProfileUtils;
import ru.yandex.chemodan.app.dataapi.apps.profile.cache.FullProfileCache;

/**
 * @author Denis Bakharev
 */
public class FullProfileCacheInvalidator implements DatabaseChangedEventAsyncHandler {

    private final FullProfileCache cache;

    public FullProfileCacheInvalidator(FullProfileCache cache) {
        this.cache = cache;
    }

    @Override
    public void databaseChanged(DatabaseChange databaseChange) {
        if (ProfileUtils.isProfileDb(databaseChange.patchedDatabase())) {
            cache.invalidateForUserAsync(databaseChange.patchedDatabase().uid);
        }
    }

}
