package ru.yandex.chemodan.app.dataapi.apps.profile.full;

import java.util.List;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.app.dataapi.apps.profile.cache.FullProfileCache;
import ru.yandex.chemodan.app.dataapi.apps.profile.cache.FullProfileCacheContextConfiguration;
import ru.yandex.chemodan.app.dataapi.core.datasources.disk.DiskDataSource;
import ru.yandex.chemodan.app.dataapi.core.manager.DataApiManager;

/**
 * @author tolmalev
 */
@Configuration
@Import({
        FullProfileCacheContextConfiguration.class
})
public class FullProfileContextConfiguration {
    @Bean
    public FullProfileManager fullProfileManager(DataApiManager dataApiManager,
            DiskDataSource diskDataSource,
            List<ProfilePartParser> parsers)
    {
        return new FullProfileManager(dataApiManager, diskDataSource, Cf.wrap(parsers));
    }

    @Bean
    public CachedFullProfileManager cachedFullProfileManager(FullProfileManager manager, FullProfileCache cache) {
        return new CachedFullProfileManager(manager, cache);
    }
}
