package ru.yandex.chemodan.app.dataapi.apps.profile.full;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRef;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.apps.profile.ProfileManagerBase;
import ru.yandex.chemodan.app.dataapi.apps.profile.ProfileUtils;
import ru.yandex.chemodan.app.dataapi.core.datasources.disk.DiskDataSource;
import ru.yandex.chemodan.app.dataapi.core.manager.DataApiManager;

/**
 * @author tolmalev
 */
public class FullProfileManager extends ProfileManagerBase {
    private final MapF<DatabaseRef, ProfilePartParser> parsers;

    FullProfileManager(DataApiManager dataApiManager, DiskDataSource diskDataSource,
            ListF<ProfilePartParser> parsers)
    {
        super(dataApiManager, diskDataSource);
        this.parsers = parsers.toMapMappingToKey(ProfilePartParser::dbRef);
    }

    public FullUserProfile getProfile(DataApiUserId uid) {
        FullUserProfileBuilder builder = new FullUserProfileBuilder();
        ListF<DataRecord> records = getRecords(uid);

        for (Tuple2<String, ListF<DataRecord>> t :
                records.groupBy(DataRecord::getDatabaseHandle).entries())
        {
            parsers.getTs(ProfileUtils.parseDbRefFromHandle(t._1))
                    .parse(builder, t._2);
        }

        return builder.build();
    }
}
