package ru.yandex.chemodan.app.dataapi.apps.profile.full;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.apps.profile.address.AddressTest;
import ru.yandex.chemodan.app.dataapi.apps.profile.events.flights.ProfileFlightsManagerTest;
import ru.yandex.chemodan.app.dataapi.apps.profile.geopoint.GeoPoint;
import ru.yandex.chemodan.app.dataapi.apps.profile.yatickets.model.OrderTest;
import ru.yandex.commune.protobuf5.Protobuf5Serializer;
import ru.yandex.misc.geo.Coordinates;
import ru.yandex.misc.test.Assert;

/**
 * @author tolmalev
 */
public class FullProfileSerializationTest {

    public static FullUserProfile sampleProfile() {
        return new FullUserProfile(
                new Addresses(
                        Cf.list(
                                AddressTest.sampleAddress(),
                                AddressTest.sampleAddress().withId("sasasd")
                        )
                ),
                new ActualEvents(
                        Cf.list(
                                ProfileFlightsManagerTest.sampleFlight()
                        )
                ),
                new GeoPoints(
                        Cf.list(
                                new GeoPoint(Option.empty(), Option.empty(), new Coordinates(1, 2), Cf.list("t1", "t2")),
                                new GeoPoint(Option.of("123"), Option.of("title"), new Coordinates(1, 2), Cf.list())
                        )
                ),
                new Orders(Cf.list(OrderTest.getSampleOrder("oid")))
        );
    }

    @Test
    public void parseSerialize() {
        FullUserProfile profile = sampleProfile();

        Protobuf5Serializer<FullUserProfile> serializer = Protobuf5Serializer.cons(FullUserProfile.class);

        byte[] bytes = serializer.serialize(profile);
        FullUserProfile deserializedProfile = serializer.deserialize(bytes);
        Assert.equals(profile.toString(), deserializedProfile.toString());
        Assert.equals(profile, deserializedProfile);
    }
}
