package ru.yandex.chemodan.app.dataapi.apps.profile.geopoint;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.api.data.record.CollectionRef;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.chemodan.app.dataapi.api.data.record.Entity;
import ru.yandex.chemodan.app.dataapi.apps.profile.ProfileRecordSupport;
import ru.yandex.chemodan.app.dataapi.apps.profile.ProfileUtils;
import ru.yandex.commune.a3.action.result.pojo.ActionResultPojo;
import ru.yandex.commune.protobuf5.annotation.ProtoField;
import ru.yandex.commune.protobuf5.annotation.ProtoMessage;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.geo.Coordinates;

/**
 * @author akirakozov
 */
@BenderBindAllFields
@ActionResultPojo
@ProtoMessage
public class GeoPoint extends ProfileRecordSupport implements Entity {
    public static final String TITLE = "title";

    public static final String LATITUDE = "latitude";
    public static final String LONGITUDE = "longitude";

    public static final String TAGS = "tags";

    private static final String DEFAULT_TITLE = "no title";

    @BenderPart(name = TITLE, strictName = true)
    @ProtoField(n = 1)
    private Option<String> title = Option.empty();

    @ProtoField(n = 2)
    private double latitude;
    @ProtoField(n = 3)
    private double longitude;

    @BenderPart(name = "geopoint_id", strictName = true)
    @ProtoField(n = 4)
    private Option<String> geoPointId;

    @BenderPart(name = TAGS, strictName = true)
    @ProtoField(n = 5)
    private ListF<String> tags = Cf.arrayList();

    public GeoPoint(Option<String> geoPointId, Option<String> title, Coordinates coordinates, ListF<String> tags) {
        this.title = title;
        this.latitude = coordinates.getLatitude();
        this.longitude = coordinates.getLongitude();
        this.geoPointId = geoPointId;
        this.tags = tags;
    }

    public GeoPoint(String geoPointId) {
        this.geoPointId = Option.of(geoPointId);
    }

    public Option<String> getTitle() {
        return title;
    }

    public void setTitle(Option<String> title) {
        this.title = title;
    }

    public double getLatitude() {
        return latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getLongitude() {
        return longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public Option<String> getGeoPointId() {
        return geoPointId;
    }

    public void setGeoPointId(Option<String> geoPointId) {
        this.geoPointId = geoPointId;
    }

    public ListF<String> getTags() {
        return tags;
    }

    public void setTags(ListF<String> tags) {
        this.tags = tags;
    }

    @Override
    public MapF<String, DataField> toDataMap() {
        MapF<String, DataField> result = Cf.map();

        result = plusStringO(result, TITLE, title);
        result = result.plus1(LATITUDE, DataField.decimal(latitude));
        result = result.plus1(LONGITUDE, DataField.decimal(longitude));

        result = plusList(result, TAGS, tags);

        return result;
    }

    public static GeoPoint fromDataRecord(DataRecord record) {
        return fromData(record.getRecordId(), record.getData());
    }

    public static GeoPoint fromData(String recordId, MapF<String, DataField> data) {
        return new GeoPoint(
                Option.of(recordId),
                data.getO(TITLE).map(DataField.stringValueF()),
                new Coordinates(
                        data.getOrElse(LATITUDE, DataField.decimal(0)).decimalValue(),
                        data.getOrElse(LONGITUDE, DataField.decimal(0)).decimalValue()
                ),

                Cf.arrayList(extractStringList(data.getO(TAGS))));
    }


    @Override
    public CollectionRef collectionRef() {
        return ProfileUtils.GEOPOINT_COL_REF;
    }

    @Override
    public String recordId() {
        return getGeoPointId().get();
    }
}
