package ru.yandex.chemodan.app.dataapi.apps.profile.geopoint;

import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.core.dao.test.ActivateDataApiEmbeddedPg;
import ru.yandex.chemodan.app.dataapi.test.DataApiTestSupport;
import ru.yandex.misc.geo.Coordinates;
import ru.yandex.misc.test.Assert;

/**
 * @author akirakozov
 */
@ActivateDataApiEmbeddedPg
public class GeoPointManagerTest extends DataApiTestSupport {

    @Autowired
    private GeoPointsManager geoPointsManager;

    @Test
    public void createFindDelete() {
        DataApiUserId uid = createRandomCleanUser();

        GeoPoint point = new GeoPoint(
                Option.empty(),
                Option.of("title"),
                new Coordinates(3, 5),
                Cf.list("tag1", "tag2"));

        GeoPoint r = geoPointsManager.saveGeoPoint(uid, point);
        point.setGeoPointId(r.getGeoPointId());

        GeoPoint result = geoPointsManager.getEntityByUidAndId(uid, point.getGeoPointId().get());
        Assert.equals(point, result);

        geoPointsManager.deleteEntity(uid, point.getGeoPointId().get());

        Assert.isEmpty(geoPointsManager.getEntityByUidAndIdO(uid, point.getGeoPointId().get()));
    }

    @Test
    public void createUpdate() {
        DataApiUserId uid = createRandomCleanUser();

        GeoPoint point = new GeoPoint(
                Option.of("123123"),
                Option.of("title"),
                new Coordinates(3, 5),
                Cf.list());

        GeoPoint r = geoPointsManager.saveGeoPoint(uid, point);
        r.setLatitude(10);
        r.setLongitude(50);
        r.setTitle(Option.of("new title"));
        r.setTags(Cf.list("tag1", "tag3"));
        geoPointsManager.saveGeoPoint(uid, point);

        GeoPoint result = geoPointsManager.getEntityByUidAndId(uid, point.getGeoPointId().get());
        Assert.equals(result, point);
    }
}
