package ru.yandex.chemodan.app.dataapi.apps.profile.geopoint;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.chemodan.app.dataapi.api.data.record.RecordIdGenerator;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.apps.profile.GenericProfileNamespaceManagerBase;
import ru.yandex.chemodan.app.dataapi.apps.profile.ProfileUtils;
import ru.yandex.chemodan.app.dataapi.apps.profile.full.FullUserProfileBuilder;
import ru.yandex.chemodan.app.dataapi.apps.profile.full.GeoPoints;
import ru.yandex.chemodan.app.dataapi.core.datasources.disk.DiskDataSource;
import ru.yandex.chemodan.app.dataapi.core.manager.DataApiManager;

/**
 * @author akirakozov
 */
public class GeoPointsManager extends GenericProfileNamespaceManagerBase<GeoPoint> {
    public GeoPointsManager(DataApiManager dataApiManager, DiskDataSource diskDataSource) {
        super(dataApiManager, diskDataSource, ProfileUtils.GEOPOINT_COL_REF, GeoPoint::fromDataRecord);
    }

    @Override
    public void parse(FullUserProfileBuilder builder, ListF<DataRecord> records) {
        builder.setGeoPoints(new GeoPoints(parseRecords(records)));
    }

    public GeoPoint saveGeoPoint(DataApiUserId uid, GeoPoint geoPoint) {
        if (!geoPoint.getGeoPointId().isPresent()) {
            geoPoint.setGeoPointId(Option.of(RecordIdGenerator.generateId()));
        }

        setEntity(uid, geoPoint);
        return geoPoint;
    }
}
