package ru.yandex.chemodan.app.dataapi.apps.profile.yatickets;

import org.joda.time.Duration;
import org.joda.time.Instant;

import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.apps.profile.yatickets.model.Order;
import ru.yandex.commune.bazinga.BazingaTaskManager;

/**
 * @author Denis Bakharev
 */
public class AsyncOrderRemover {
    private final BazingaTaskManager bazingaTaskManager;
    private final Duration deleteInterval;

    public AsyncOrderRemover(BazingaTaskManager bazingaTaskManager, Duration deleteInterval) {
        this.bazingaTaskManager = bazingaTaskManager;
        this.deleteInterval = deleteInterval;
    }

    public void scheduleOrderDeletion(DataApiUserId uid, Order order) {
        Instant deletionTime = getDeletionTime(order);
        bazingaTaskManager.schedule(new DeleteOrderTask(uid, order.getOrderId()), deletionTime);
    }

    private Instant getDeletionTime(Order order) {
        return order.session.date.toInstant().plus(deleteInterval);
    }

    public boolean isCorrectDeletionDate(Order order, Instant dateForDeletion) {
        return getDeletionTime(order).isBefore(dateForDeletion);
    }
}
