package ru.yandex.chemodan.app.dataapi.apps.profile.yatickets;

import org.joda.time.Duration;

import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.worker.DataApiTaskQueueName;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;

/**
 * @author Denis Bakharev
 */
public class DeleteOrderTask extends OnetimeTaskSupport<DeleteOrderTask.Parameters> {

    private final OrdersManager ordersManager;

    public DeleteOrderTask(DataApiUserId uid, String orderId) {
        super(new Parameters(uid, orderId));
        ordersManager = null;
    }

    public DeleteOrderTask(OrdersManager ordersManager) {
        super(Parameters.class);
        this.ordersManager = ordersManager;
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardMinutes(5);
    }

    @Override
    protected void execute(Parameters parameters, ExecutionContext context) throws Exception {
        ordersManager.deleteOutdatedOrder(parameters.uid, parameters.orderId);
    }

    @Override
    public TaskQueueName queueName() {
        return DataApiTaskQueueName.DATAAPI_REGULAR;
    }

    @BenderBindAllFields
    public static final class Parameters {
        public final DataApiUserId uid;
        public final String orderId;

        Parameters(DataApiUserId uid, String orderId) {
            this.uid = uid;
            this.orderId = orderId;
        }
    }
}
