package ru.yandex.chemodan.app.dataapi.apps.profile.yatickets;

import ru.yandex.chemodan.app.dataapi.api.OneCollectionChangesAsyncHandlerSupport;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.chemodan.app.dataapi.api.deltas.DatabaseChange;
import ru.yandex.chemodan.app.dataapi.apps.profile.ProfileUtils;
import ru.yandex.chemodan.app.dataapi.apps.profile.yatickets.model.Order;
import ru.yandex.chemodan.app.dataapi.utils.serializers.datafieldmap.DataFieldMapSerializer;

/**
 * @author Denis Bakharev
 */
public class OrderChangesAsyncHandler extends OneCollectionChangesAsyncHandlerSupport {
    private static final DataFieldMapSerializer<Order> serializer = new DataFieldMapSerializer<>(Order.class);

    private final AsyncOrderRemover asyncOrderRemover;

    public OrderChangesAsyncHandler(AsyncOrderRemover asyncOrderRemover) {
        super(ProfileUtils.YATICKETS_ORDERS_COL_REF);
        this.asyncOrderRemover = asyncOrderRemover;
    }

    @Override
    protected void collectionChanged(DatabaseChange change) {
        for (DataRecord record : change.getPatchedRecords()) {
            Order order = serializer.deserialize(record.getData());
            asyncOrderRemover.scheduleOrderDeletion(record.uid, order);
        }
    }
}
