package ru.yandex.chemodan.app.dataapi.apps.profile.yatickets;

import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.app.dataapi.core.datasources.disk.DiskDataSource;
import ru.yandex.chemodan.app.dataapi.core.manager.DataApiManager;
import ru.yandex.commune.bazinga.BazingaTaskManager;

/**
 * @author Denis Bakharev
 */
@Configuration
public class OrdersContextConfiguration {
    @Bean
    public OrdersManager ordersManager(DataApiManager dm,
            DiskDataSource diskDataSource,
            AsyncOrderRemover orderRemover)
    {
        return new OrdersManager(dm, diskDataSource, orderRemover);
    }

    @Bean
    public DeleteOrderTask deleteOrderTask(OrdersManager ordersManager) {
        return new DeleteOrderTask(ordersManager);
    }

    @Bean
    public AsyncOrderRemover asyncOrderRemover(
            BazingaTaskManager bazingaTaskManager,
            @Value("${dataapi.apps.profile.yatickets.order.deletion-interval}")
            Duration deleteInterval)
    {
        return new AsyncOrderRemover(bazingaTaskManager, deleteInterval);
    }

    @Bean
    public OrderChangesAsyncHandler orderChangesAsyncHandler(AsyncOrderRemover remover) {
        return new OrderChangesAsyncHandler(remover);
    }
}
