package ru.yandex.chemodan.app.dataapi.apps.profile.yatickets;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.apps.profile.GenericProfileNamespaceManagerBase;
import ru.yandex.chemodan.app.dataapi.apps.profile.ProfileUtils;
import ru.yandex.chemodan.app.dataapi.apps.profile.full.FullUserProfileBuilder;
import ru.yandex.chemodan.app.dataapi.apps.profile.full.Orders;
import ru.yandex.chemodan.app.dataapi.apps.profile.yatickets.model.Order;
import ru.yandex.chemodan.app.dataapi.core.datasources.disk.DiskDataSource;
import ru.yandex.chemodan.app.dataapi.core.manager.DataApiManager;

/**
 * @author Denis Bakharev
 */
public class OrdersManager extends GenericProfileNamespaceManagerBase<Order> {
    private final AsyncOrderRemover asyncOrderRemover;

    public OrdersManager(DataApiManager dataApiManager, DiskDataSource diskDataSource,
            AsyncOrderRemover asyncOrderRemover)
    {
        super(
                dataApiManager,
                diskDataSource,
                ProfileUtils.YATICKETS_ORDERS_COL_REF,
                Order::fromDataRecord);

        this.asyncOrderRemover = asyncOrderRemover;
    }

    public boolean deleteOutdatedOrder(DataApiUserId uid, String orderId) {
        Option<Order> orderO = getEntityByUidAndIdO(uid, orderId);
        if (orderO.isPresent()) {
            Order order = orderO.get();
            if (asyncOrderRemover.isCorrectDeletionDate(order, Instant.now())) {
                deleteEntity(uid, order);
                return true;
            } else {
                asyncOrderRemover.scheduleOrderDeletion(uid, order);
            }
        }

        return false;
    }

    @Override
    public void parse(FullUserProfileBuilder builder, ListF<DataRecord> records) {
        builder.setOrders(new Orders(parseRecords(records)));
    }
}
