package ru.yandex.chemodan.app.dataapi.apps.profile.yatickets.model;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.api.data.record.CollectionRef;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.chemodan.app.dataapi.api.data.record.Entity;
import ru.yandex.chemodan.app.dataapi.apps.profile.ProfileUtils;
import ru.yandex.chemodan.app.dataapi.utils.serializers.datafieldmap.DataFieldMapSerializer;
import ru.yandex.commune.a3.action.result.pojo.ActionResultPojo;
import ru.yandex.commune.protobuf5.annotation.ProtoField;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Denis Bakharev
 */
@BenderBindAllFields
@ActionResultPojo
public class Order extends DefaultObject implements Entity {
    private static final DataFieldMapSerializer<Order> serializer = new DataFieldMapSerializer<>(Order.class);

    @ProtoField(n = 1)
    @BenderPart(name = "order_id", strictName = true)
    public final String orderId;
    @ProtoField(n = 2)
    public final Session session;
    @ProtoField(n = 3)
    @BenderPart(name = "ticket_count", strictName = true)
    public final int ticketCount;
    @ProtoField(n = 4)
    @BenderPart(name = "order_number", strictName = true)
    public final Option<String> orderNumber;
    @ProtoField(n = 5)
    @BenderPart(name = "presentation_order_number", strictName = true)
    public final Option<String> presentationOrderNumber;
    @BenderPart(name = "code_word", strictName = true)
    @ProtoField(n = 6)
    public final Option<String> codeWord;
    @ProtoField(n = 7)
    public final Option<Barcode> barcode;
    @BenderPart(name = "pkpass_barcode", strictName = true)
    @ProtoField(n = 8)
    public final Option<Barcode> pkpassBarcode;
    @ProtoField(n = 9)
    public final ListF<Ticket> tickets;

    public Order(
            String orderId,
            Session session,
            int ticketCount,
            Option<String> orderNumber,
            Option<String> presentationOrderNumber,
            Option<String> codeWord,
            Option<Barcode> barcode,
            Option<Barcode> pkpassBarcode,
            ListF<Ticket> tickets)
    {
        this.orderId = orderId;
        this.session = session;
        this.ticketCount = ticketCount;
        this.orderNumber = orderNumber;
        this.presentationOrderNumber = presentationOrderNumber;
        this.codeWord = codeWord;
        this.barcode = barcode;
        this.pkpassBarcode = pkpassBarcode;
        this.tickets = tickets;
    }

    public static Order fromDataRecord(DataRecord record) {
        return serializer.deserialize(record.getData());
    }

    @Override
    public CollectionRef collectionRef() {
        return ProfileUtils.YATICKETS_ORDERS_COL_REF;
    }

    @Override
    public String recordId() {
        return getOrderId();
    }

    @Override
    public MapF<String, DataField> toDataMap() {
        return serializer.serialize(this);
    }

    public String getOrderId() {
        return orderId;
    }
}
