package ru.yandex.chemodan.app.dataapi.apps.profile.yatickets.model;

import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.protobuf5.Protobuf5Serializer;
import ru.yandex.misc.test.Assert;

/**
 * @author Denis Bakharev
 */
public class OrderTest {
    public static Order getSampleOrder(String orderId, DateTime date) {
        return getSampleOrder(orderId, getSession(date));
    }

    public static Order getSampleOrder(String orderId, Session session) {
        return new Order(orderId, session, 1, Option.empty(), Option.empty(), Option.empty(),
                Option.of(new Barcode("url", 100, 200)),
                Option.of(new Barcode("url2", 300, 400)),
                Cf.list(new Ticket(
                        Option.of("1"), Option.of("2"),
                        Option.of("asdasd"),
                        false,
                        Option.of("A"), Option.of("B"), Option.of("C")
                ), new Ticket(
                        Option.empty(), Option.empty(),
                        Option.empty(),
                        true,
                        Option.empty(), Option.empty(), Option.empty())));
    }

    public static Order getSampleOrder(String orderId) {
        return getSampleOrder(orderId, getSession());
    }

    private static Session getSession(DateTime date) {
        return new Session(
                100,
                date,
                Option.of(new DateTime(2014, 3, 13, 20, 0, DateTimeZone.forOffsetHours(5))),
                Option.of(1),
                new Event(111, Option.of("type"), "name"),
                getVenue(),
                new Hall("myHall"));
    }

    private static Session getSession() {
        return getSession (new DateTime(2015, 3, 13, 20, 0, DateTimeZone.forOffsetHours(9)));
    }

    private static Venue getVenue() {
        return new Venue(
                200,
                Cf.list(),
                "name",
                "address",
                1,
                new ru.yandex.chemodan.app.dataapi.apps.profile.yatickets.model.Coordinates(1, 2),
                false,
                Cf.list());
    }

    @Test
    public void protobufSerialization() {
        Protobuf5Serializer<Order> serializer = Protobuf5Serializer.cons(Order.class);
        Order order = getSampleOrder("uid");

        byte[] bytes = serializer.serialize(order);
        Order deserializedOrder = serializer.deserialize(bytes);
        Assert.equals(order.toString(), deserializedOrder.toString());
        Assert.equals(order, deserializedOrder);
    }
}
