package ru.yandex.chemodan.app.dataapi.apps.profile.yatickets.model;

import org.joda.time.DateTime;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.data.protobuf.ProtobufDateTime;
import ru.yandex.commune.protobuf5.annotation.ProtoField;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Denis Bakharev
 */
@BenderBindAllFields
public class Session extends DefaultObject {
    @ProtoField(n = 1)
    public final int id;
    @ProtoField(n = 2, replace = ProtobufDateTime.class)
    public final DateTime date;
    @BenderPart(name = "previous_date", strictName = true)
    @ProtoField(n = 3, replace = ProtobufDateTime.class)
    public final Option<DateTime> previousDate;
    @ProtoField(n = 4)
    public final Option<Integer> duration;
    @ProtoField(n = 5)
    public final Event event;
    @ProtoField(n = 6)
    public final Venue venue;
    @ProtoField(n = 7)
    public final Hall hall;

    public Session(
            int id,
            DateTime date,
            Option<DateTime> previousDate,
            Option<Integer> duration,
            Event event,
            Venue venue,
            Hall hall)
    {
        this.id = id;
        this.date = date;
        this.previousDate = previousDate;
        this.duration = duration;
        this.event = event;
        this.venue = venue;
        this.hall = hall;
    }
}
