package ru.yandex.chemodan.app.dataapi.apps.profile.yatickets.model;

import ru.yandex.bolts.collection.Option;
import ru.yandex.commune.protobuf5.annotation.ProtoField;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderDefaultValue;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Denis Bakharev
 */
@BenderBindAllFields
public class Ticket extends DefaultObject {
    @ProtoField(n = 1)
    public final Option<String> row;
    @ProtoField(n = 2)
    public final Option<String> place;
    @ProtoField(n=3)
    @BenderPart(name = "ticket_number", strictName = true)
    public final Option<String> ticketNumber;
    @ProtoField(n=4)
    @BenderDefaultValue("false")
    public final boolean admission;
    @ProtoField(n=5)
    @BenderPart(name = "level_name", strictName = true)
    public final Option<String> levelName;
    @ProtoField(n=6)
    @BenderPart(name = "category_name", strictName = true)
    public final Option<String> categoryName;
    @ProtoField(n=7)
    @BenderPart(name = "entrance_name", strictName = true)
    public final Option<String> entranceName;

    public Ticket(Option<String> row, Option<String> place, Option<String> ticketNumber, boolean admission,
            Option<String> levelName, Option<String> categoryName, Option<String> entranceName)
    {
        this.row = row;
        this.place = place;
        this.ticketNumber = ticketNumber;
        this.admission = admission;
        this.levelName = levelName;
        this.categoryName = categoryName;
        this.entranceName = entranceName;
    }
}
