package ru.yandex.chemodan.app.dataapi.apps.profile.yatickets.model;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.commune.protobuf5.annotation.ProtoField;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Denis Bakharev
 */
@BenderBindAllFields
public class Venue extends DefaultObject {
    @ProtoField(n = 1)
    public final int id;
    @ProtoField(n = 2)
    public final ListF<String> types;
    @ProtoField(n = 3)
    public final String name;
    @ProtoField(n = 4)
    public final String address;
    @BenderPart(name = "region_id", strictName = true)
    @ProtoField(n = 5)
    public final int regionId;
    @ProtoField(n = 6)
    public final Coordinates coordinates;
    @ProtoField(n = 7)
    public final boolean smartpass;
    @ProtoField(n = 8)
    public final ListF<SubwayStation> subway;

    public Venue(
            int id,
            ListF<String> types,
            String name,
            String address,
            int regionId,
            Coordinates coordinates,
            boolean smartpass,
            ListF<SubwayStation> subway)
    {
        this.id = id;
        this.types = types;
        this.name = name;
        this.address = address;
        this.regionId = regionId;
        this.coordinates = coordinates;
        this.smartpass = smartpass;
        this.subway = subway;
    }


}
