package ru.yandex.chemodan.app.dataapi.apps.settings;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRef;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRefSource;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderDefaultValue;
import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;

/**
 * @author Denis Bakharev
 */
@BenderBindAllFields
public class AppDatabaseSettings {
    public static final AppDatabaseSettings DEFAULT =
            new AppDatabaseSettings(Option.empty(), Option.empty());

    public final Option<String> appName;
    public final Option<String> databaseId;

    @BenderDefaultValue("false")
    public boolean useCache = false;
    @BenderDefaultValue("false")
    public boolean noKeepDeltas = false;
    @BenderDefaultValue("false")
    public boolean noXiva = false;
    @BenderDefaultValue("false")
    public boolean haveDumpInYt = false;

    @BenderDefaultValue("R_MS")
    public MasterSlavePolicy snapshotPolicy = MasterSlavePolicy.R_MS;
    @BenderDefaultValue("R_MS")
    public MasterSlavePolicy listDeltasPolicy = MasterSlavePolicy.R_MS;

    public Option<DataSize> databaseSizeLimit = Option.empty();
    public Option<Integer> databaseRecordsCountLimit = Option.empty();

    public Option<String> lbPushLogTypeName = Option.empty();

    public AppDatabaseSettings(DatabaseRef ref) {
        appName = ref.appNameO();
        databaseId = Option.of(ref.databaseId());
    }

    public AppDatabaseSettings(Option<String> appName, Option<String> databaseId) {
        this.appName = appName;
        this.databaseId = databaseId;
    }

    public boolean isUseCache() {
        return useCache;
    }

    public boolean isKeepDeltas() {
        return !isNoKeepDeltas();
    }

    public boolean isNoKeepDeltas() {
        return noKeepDeltas;
    }

    public boolean isNoXiva() {
        return noXiva;
    }

    public boolean isHaveDumpInYt() {
        return haveDumpInYt;
    }

    public AppDatabaseSettings enableCaching() {
        useCache = true;
        return this;
    }

    public AppDatabaseSettings doNotKeepDeltas() {
        noKeepDeltas = true;
        return this;
    }

    public AppDatabaseSettings enableDumpingInYt() {
        haveDumpInYt = true;
        return this;
    }

    boolean isFor(Option<DatabaseRefSource> dbRefSrc) {
        return isForDbId(dbRefSrc.map(DatabaseRefSource::databaseId));
    }

    boolean isForDbId(Option<String> databaseId) {
        return this.databaseId.equals(databaseId);
    }

    AppDatabaseSettings withDefaultDatabaseSizeLimit(DataSize databaseSizeLimit) {
        this.databaseSizeLimit = this.databaseSizeLimit.orElse(Option.of(databaseSizeLimit));
        return this;
    }

    public DataSize getDatabaseSizeLimit() {
        return databaseSizeLimit.get();
    }

    public Option<Integer> getDatabaseRecordsCountLimit() {
        return databaseRecordsCountLimit;
    }

    public Option<String> getLbPushLogTypeName() {
        return lbPushLogTypeName;
    }

    public AppDatabaseSettings setUseCache(boolean useCache) {
        this.useCache = useCache;
        return this;
    }

    public AppDatabaseSettings setNoKeepDeltas(boolean noKeepDeltas) {
        this.noKeepDeltas = noKeepDeltas;
        return this;
    }

    public AppDatabaseSettings setNoXiva(boolean noXiva) {
        this.noXiva = noXiva;
        return this;
    }

    public AppDatabaseSettings setHaveDumpInYt(boolean haveDumpInYt) {
        this.haveDumpInYt = haveDumpInYt;
        return this;
    }

    public AppDatabaseSettings setGetSnapshotPolicy(MasterSlavePolicy getSnapshotPolicy) {
        this.snapshotPolicy = getSnapshotPolicy;
        return this;
    }

    public AppDatabaseSettings setListDeltasPolicy(MasterSlavePolicy listDeltasPolicy) {
        this.listDeltasPolicy = listDeltasPolicy;
        return this;
    }

    public AppDatabaseSettings setDatabaseSizeLimit(Option<DataSize> databaseSizeLimit) {
        this.databaseSizeLimit = databaseSizeLimit;
        return this;
    }

    public AppDatabaseSettings setDatabaseRecordsCountLimit(Option<Integer> databaseRecordsCountLimit) {
        this.databaseRecordsCountLimit = databaseRecordsCountLimit;
        return this;
    }

    public AppDatabaseSettings setLbPushLogTypeName(Option<String> lbPushLogTypeName) {
        this.lbPushLogTypeName = lbPushLogTypeName;
        return this;
    }
}
