package ru.yandex.chemodan.app.dataapi.core.dao;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;
import ru.yandex.chemodan.util.jdbc.DataSourceProperties;
import ru.yandex.chemodan.util.jdbc.JdbcDatabaseConfigurator;
import ru.yandex.chemodan.util.jdbc.JdbcDatabaseConfiguratorContextConfiguration;
import ru.yandex.chemodan.util.jdbc.SharpeiProperties;
import ru.yandex.chemodan.util.sharpei.SharpeiClient;
import ru.yandex.chemodan.util.sharpei.SharpeiHttpClient;
import ru.yandex.misc.db.embedded.ConditionalOnMissingEmbeddedDb;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Configuration
@Import(JdbcDatabaseConfiguratorContextConfiguration.class)
@ConditionalOnMissingEmbeddedDb
public class DataApiDbConfiguratorsConfig {

    @Autowired
    private JdbcDatabaseConfiguratorContextConfiguration dbConfiguratorConfig;

    @Bean
    @OverridableValuePrefix("dataapi")
    public DataSourceProperties dataapiDataSourceProperties() {
        return new DataSourceProperties();
    }

    @Bean
    @OverridableValuePrefix("dataapi")
    public SharpeiProperties dataapiSharpeiProperties() {
        return new SharpeiProperties();
    }

    @Bean
    public SharpeiClient configureSharpeiClient(SharpeiProperties dataapiSharpeiProperties) {
        return new SharpeiHttpClient(dataapiSharpeiProperties.getSharpeiBaseUrl(), dataapiSharpeiHttpClientConfigurator().configure());
    }

    @Bean
    @OverridableValuePrefix("dataapi.sharpei")
    public HttpClientConfigurator dataapiSharpeiHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }

    @Bean
    public JdbcDatabaseConfigurator dataapiDbConfigurator(
            DataSourceProperties dataapiDataSourceProperties,
            SharpeiClient sharpeiClient)
    {
        return dbConfiguratorConfig.consSharpeiJdbcConfigurator(dataapiDataSourceProperties, sharpeiClient);
    }
}
