package ru.yandex.chemodan.app.dataapi.core.dao;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.core.dao.usermeta.MetaUser;
import ru.yandex.chemodan.app.dataapi.core.dao.usermeta.UserMetaManager;
import ru.yandex.chemodan.app.dataapi.web.UserNotFoundException;
import ru.yandex.commune.db.shard.proxy.Discriminant;
import ru.yandex.commune.db.shard.spring.ShardResolver;

/**
 * @author tolmalev
 */
public class DataApiShardResolver implements ShardResolver {

    private final UserMetaManager userMetaManager;
    private final ListF<Integer> shardIds;

    public DataApiShardResolver(ru.yandex.chemodan.app.dataapi.core.dao.usermeta.UserMetaManager userMetaManager,
        ListF<Integer> shardIds)
    {
        this.userMetaManager = userMetaManager;
        this.shardIds = shardIds;
    }

    public Option<UserShardInfo> shardByUserIdO(DataApiUserId userId, boolean forRead) {
        if (ForcedUserShardInfoHolder.holdsUser(userId)) {
            return ForcedUserShardInfoHolder.getO();
        }
        Option<MetaUser> userO = userMetaManager.findMetaUser(userId, forRead);
        if (!userO.isPresent() && forRead && shardIds.isNotEmpty()) {
            int shardId = shardIds.get((int) (userId.discriminant() % shardIds.size()));
            return Option.of(new UserShardInfo(userId, false, shardId));
        }
        return userO.map(UserShardInfo::fromMetaUser);
    }

    public Option<UserShardInfo> shardByUserIdO(DataApiUserId userId) {
        return shardByUserIdO(userId, false);
    }

    public UserShardInfo shardByUserId(DataApiUserId userId) {
        return shardByUserIdO(userId).getOrThrow(UserNotFoundException.consF(userId));
    }

    public UserShardInfo shardByUserId(DataApiUserId userId, boolean forRead) {
        return shardByUserIdO(userId, forRead).getOrThrow(UserNotFoundException.consF(userId));
    }

    @Override
    public int shardByDiscriminant(Discriminant discriminant) {
        if (discriminant instanceof DataApiUserId) {
            return shardByUserId((DataApiUserId) discriminant).shardId;
        } else {
            throw new IllegalArgumentException("Can't get shard for " + discriminant);
        }
    }
}
