package ru.yandex.chemodan.app.dataapi.core.dao;

import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.dataapi.core.dao.usermeta.SharpeiUserMetaManager;
import ru.yandex.chemodan.app.dataapi.core.dao.usermeta.UserMetaManager;
import ru.yandex.chemodan.util.retry.RetryConf;
import ru.yandex.chemodan.util.sharpei.SharpeiCachingManager;
import ru.yandex.chemodan.util.sharpei.SharpeiClient;
import ru.yandex.chemodan.util.sharpei.SharpeiClientWithRetries;
import ru.yandex.chemodan.util.sharpei.SharpeiManager;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author tolmalev
 */
@Configuration
@Import(DataApiDbConfiguratorsConfig.class)
public class DataApiUserMetaContextConfiguration {

    @SuppressWarnings("unused")
    private static final Logger logger =
            LoggerFactory.getLogger(DataApiUserMetaContextConfiguration.class);

    @Bean
    public UserMetaManager userMetaManager(
            SharpeiClient client,
            @Value("${dataapi.sharpei.disable-cache:-false}") boolean disableSharpeiCache)
    {
        SharpeiClientWithRetries retryingClient = new SharpeiClientWithRetries(client,
                new RetryConf(9, Duration.millis(100)), new RetryConf(2, Duration.ZERO));

        SharpeiManager sharpeiManager = disableSharpeiCache
                ? new SharpeiManager(retryingClient)
                : new SharpeiCachingManager(retryingClient);

        return new SharpeiUserMetaManager(retryingClient, sharpeiManager);
    }
}
