package ru.yandex.chemodan.app.dataapi.core.dao;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.misc.ThreadLocalX;

/**
 * @author dbrylev
 */
public class ForcedUserShardInfoHolder {
    private static final ThreadLocalX<UserShardInfo> userShardInfo = new ThreadLocalX<>();

    public static boolean holdsUser(DataApiUserId uid) {
        return userShardInfo.isSet() && userShardInfo.get().userId.equals(uid);
    }

    public static Option<UserShardInfo> getO() {
        return userShardInfo.getO();
    }

    public static void set(UserShardInfo info) {
        userShardInfo.set(info);
    }

    public static void remove() {
        userShardInfo.remove();
    }
}
