package ru.yandex.chemodan.app.dataapi.core.dao;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;

import ru.yandex.chemodan.app.dataapi.api.deltas.DeltasJdbcDao;
import ru.yandex.chemodan.app.dataapi.api.deltas.DeltasJdbcDaoImpl;
import ru.yandex.chemodan.app.dataapi.core.dao.data.DataRecordsJdbcDao;
import ru.yandex.chemodan.app.dataapi.core.dao.data.DataRecordsJdbcDaoImpl;
import ru.yandex.chemodan.app.dataapi.core.dao.data.DatabasesJdbcDao;
import ru.yandex.chemodan.app.dataapi.core.dao.data.DatabasesJdbcDaoImpl;
import ru.yandex.chemodan.app.dataapi.core.dao.data.DatabasesJdbcDaoProperties;
import ru.yandex.chemodan.app.dataapi.core.dao.data.DeletedDatabasesJdbcDao;
import ru.yandex.chemodan.app.dataapi.core.dao.data.DeletedDatabasesJdbcDaoImpl;
import ru.yandex.chemodan.app.dataapi.core.dao.support.ShardedTransactionManager;
import ru.yandex.chemodan.app.dataapi.core.mdssnapshot.MdsSnapshotReferenceJdbcDao;
import ru.yandex.chemodan.app.dataapi.core.mdssnapshot.MdsSnapshotReferenceJdbcDaoImpl;
import ru.yandex.chemodan.app.dataapi.maintenance.ProtobufToJsonbMigrationManager;
import ru.yandex.chemodan.util.jdbc.logging.LoggingQueryInterceptorConfiguration;
import ru.yandex.chemodan.util.jdbc.logging.LoggingQueryInterceptorConfigurationContextConfiguration;
import ru.yandex.commune.dynproperties.DynamicPropertyManager;
import ru.yandex.misc.version.AppName;

/**
 * @author tolmalev
 *
 *  Информация о схеме БД:
 *  https://wiki.yandex-team.ru/disk/data-api/%D1%80%D0%B0%D0%B7%D1%80%D0%B0%D0%B1%D0%BE%D1%82%D0%BA%D0%B0#sxemabddataapi
 *  https://github.yandex-team.ru/mail/pg/tree/salt/dataapidb
 */
@Configuration
@Import({LoggingQueryInterceptorConfigurationContextConfiguration.class, JdbcDaoContextConfiguration.ProxyConfig.class})
public class JdbcDaoContextConfiguration {
    @Autowired
    private ShardPartitionDataSource dataSource;

    @Autowired
    private NotFoundHandler.ProxyCreator proxyCreator;

    @Autowired
    private AppName appName;

    @Bean
    public ShardedTransactionManager transactionManager(LoggingQueryInterceptorConfiguration loggingQueryConf) {
        return new ShardedTransactionManager(dataSource.shardManager, dataSource.shardResolver, loggingQueryConf);
    }

    @Bean
    public ProtobufToJsonbMigrationManager protobufToJsonbMigrationManager() {
        return new ProtobufToJsonbMigrationManager();
    }

    @Bean // for RunWithRandomTest
    protected DataRecordsJdbcDaoImpl dataRecordsJdbcDaoImpl() {
        return new DataRecordsJdbcDaoImpl(dataSource);
    }

    @Bean // for RunWithRandomTest
    protected DeltasJdbcDaoImpl deltasJdbcDaoImpl() {
        return new DeltasJdbcDaoImpl(dataSource);
    }

    @Bean // for RunWithRandomTest
    protected DatabasesJdbcDaoImpl databasesJdbcDaoImpl(DeletedDatabasesJdbcDao deletedDatabasesJdbcDao,
                                                        DatabasesJdbcDaoProperties databasesJdbcDaoProperties) {
        return new DatabasesJdbcDaoImpl(dataSource, deletedDatabasesJdbcDao, databasesJdbcDaoProperties);
    }

    @Bean // for RunWithRandomTest
    protected DeletedDatabasesJdbcDaoImpl deletedDatabasesDaoImpl() {
        return new DeletedDatabasesJdbcDaoImpl(dataSource);
    }

    @Bean // for RunWithRandomTest
    protected MdsSnapshotReferenceJdbcDaoImpl mdsSnapshotJdbcDaoImpl() {
        return new MdsSnapshotReferenceJdbcDaoImpl(dataSource);
    }

    @Bean
    public DatabasesJdbcDaoProperties databasesJdbcDaoProperties(DynamicPropertyManager dynamicPropertyManager) {
        return new DatabasesJdbcDaoProperties(appName, dynamicPropertyManager);
    }

    @Bean
    @Primary
    public DataRecordsJdbcDao dataRecordsJdbcDao() {
        return getProxy(DataRecordsJdbcDao.class, dataRecordsJdbcDaoImpl());
    }

    @Bean
    @Primary
    public DeltasJdbcDao deltasJdbcDao() {
        return getProxy(DeltasJdbcDao.class, deltasJdbcDaoImpl());
    }

    @Bean
    @Primary
    public DatabasesJdbcDao databasesJdbcDao(DeletedDatabasesJdbcDao deletedDatabasesDao,
                                             DatabasesJdbcDaoProperties databasesJdbcDaoProperties) {
        return getProxy(DatabasesJdbcDao.class, databasesJdbcDaoImpl(deletedDatabasesDao, databasesJdbcDaoProperties));
    }

    @Bean
    @Primary
    public DeletedDatabasesJdbcDao deletedDatabasesDao() {
        return getProxy(DeletedDatabasesJdbcDao.class, deletedDatabasesDaoImpl());
    }

    @Bean
    @Primary
    public MdsSnapshotReferenceJdbcDao mdsSnapshotJdbcDao() {
        return getProxy(MdsSnapshotReferenceJdbcDao.class, mdsSnapshotJdbcDaoImpl());
    }

    private <T> T getProxy(Class<T> clazz, T target) {
        return proxyCreator.getProxy(clazz, target);
    }

    @Configuration
    static class ProxyConfig {
        @Bean
        public NotFoundHandler.ProxyCreator proxyCreator() {
            return NotFoundHandler.ProxyCreator.DEFAULT;
        }
    }
}
