package ru.yandex.chemodan.app.dataapi.core.dao;

import java.sql.PreparedStatement;
import java.sql.SQLException;

import org.springframework.jdbc.core.BatchPreparedStatementSetter;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function;
import ru.yandex.misc.spring.jdbc.ArgPreparedStatementSetter;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;

/**
 * @author dbrylev
 */
public class JdbcDaoUtils {

    public static <T> void updateRowOrBatch(
            JdbcTemplate3 template, String query, ListF<T> rows, Function<T, ListF<Object>> argsF)
    {
        if (rows.size() == 1) {
            template.updateRow(query, argsF.apply(rows.single()));
        } else if (rows.size() > 1) {
            template.batchUpdate(query, batchStatementSetter(rows, argsF));
        }
    }

    public static <T> BatchPreparedStatementSetter batchStatementSetter(
            ListF<T> rows, Function<T, ListF<Object>> argsF)
    {
        return new BatchPreparedStatementSetter() {
            @Override
            public void setValues(PreparedStatement ps, int i) throws SQLException {
                new ArgPreparedStatementSetter(argsF.apply(rows.get(i))).setValues(ps);
            }

            @Override
            public int getBatchSize() {
                return rows.size();
            }
        };
    }
}
