package ru.yandex.chemodan.app.dataapi.core.dao;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.chemodan.app.dataapi.core.dao.support.DataApiMasterSlavePolicyQueryInterceptor;
import ru.yandex.chemodan.app.dataapi.core.dao.usermeta.UserMetaManager;
import ru.yandex.chemodan.util.jdbc.JdbcDatabaseConfigurator;
import ru.yandex.chemodan.util.jdbc.JdbcTemplateParams;
import ru.yandex.chemodan.util.jdbc.logging.LastAccessedDsSource;
import ru.yandex.commune.db.partition.PartitionResolver;
import ru.yandex.commune.db.partition.PartitionsLoader;
import ru.yandex.commune.db.partition.SimplePartitionResolver;
import ru.yandex.commune.db.shard2.ShardManager2;
import ru.yandex.misc.spring.jdbc.intercept.QueryInterceptors;

/**
 * @author tolmalev
 */
@Import({
        JdbcDaoContextConfiguration.class,
        DataApiDbConfiguratorsConfig.class
})
@Configuration
public class JdbcShardContextConfiguration {

    @Bean
    public ShardPartitionDataSource shardPartitionDataSource(
            ShardManager2 dataShardManager,
            DataApiShardResolver shardResolver, PartitionResolver partitionResolver)
    {
        return new ShardPartitionDataSource(dataShardManager, shardResolver, partitionResolver);
    }

    @Bean
    public ShardManager2 dataShardManager(
            DataApiShardResolver shardResolver,
            JdbcDatabaseConfigurator dataapiDbConfigurator)
    {
        JdbcTemplateParams templateParams =
                dataapiDbConfigurator.consTemplateParams()
                        .withInterceptorF(
                                ds -> QueryInterceptors.combine(
                                        new QueryInterceptors.WtdQueryInterceptor(),
                                        new QueryInterceptors.TltQueryInterceptor(),
                                        new DataApiMasterSlavePolicyQueryInterceptor(),
                                        ((LastAccessedDsSource) ds).getLastAccessedDsInterceptor()
                                )
                        );
        return dataapiDbConfigurator.configureSharded(shardResolver, templateParams);
    }

    @Bean
    public DataApiShardResolver dataapiShardResolver(UserMetaManager userMetaManager) {
        return new DataApiShardResolver(userMetaManager, Cf.list());

    }

    @Bean
    public PartitionResolver partitionResolver(
            @Value("${dataapi.shard.partitions.properties.path}") String path)
    {
        PartitionsLoader partitionsLoader = new PartitionsLoader();
        partitionsLoader.setPath(path);
        return new SimplePartitionResolver(partitionsLoader.getPartitions());
    }

}
