package ru.yandex.chemodan.app.dataapi.core.dao;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.app.dataapi.api.context.DatabaseContextSource;
import ru.yandex.chemodan.app.dataapi.api.db.handle.DatabaseHandles;
import ru.yandex.chemodan.app.dataapi.web.UserNotFoundException;
import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.dataSize.DataSize;

/**
 * @author tolmalev
 */
public class NotFoundHandler implements InvocationHandler {
    private final Object target;

    private final MapF<Class, Function<Object[], Object>> constructors = Cf.hashMap();

    public NotFoundHandler(Object target) {
        this.target = target;

        constructors.put(Integer.class, (args) -> (Integer) 0);
        constructors.put(int.class, (args) -> (int) 0);
        constructors.put(Long.class, (args) -> (Long) 0L);
        constructors.put(long.class, (args) -> 0L);

        constructors.put(Option.class, (args) -> Option.empty());
        constructors.put(ListF.class, (args) -> Cf.list());
        constructors.put(List.class, (args) -> Cf.list());

        constructors.put(DataSize.class, (args) -> DataSize.ZERO);

        constructors.put(DatabaseHandles.class, (args) -> {

            Object contextSource = Cf.x(args).find(arg -> arg instanceof DatabaseContextSource).get();

            return new DatabaseHandles((DatabaseContextSource) contextSource, Cf.list());
        });
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            return invokeSimple(method, args);
        } catch (UserNotFoundException e) {
            if ((method.getName().startsWith("find") || method.getName().startsWith("count"))
                    && constructors.containsKeyTs(method.getReturnType()))
            {
                return constructors.getTs(method.getReturnType()).apply(args);
            }
            throw e;
        }
    }

    private Object invokeSimple(Method method, Object[] args) throws Throwable {
        try {
            return method.invoke(target, args);
        } catch (IllegalAccessException e) {
            // impossible
            throw ExceptionUtils.translate(e);
        } catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    public interface ProxyCreator {
        <T> T getProxy(Class<T> clazz, T target);

        @SuppressWarnings("unchecked")
        static <T> T getProxy(Class<T> clazz, NotFoundHandler handler) {
            return (T) Proxy.newProxyInstance(
                    clazz.getClassLoader(),
                    new Class[] { clazz },
                    handler
            );
        }

        ProxyCreator DEFAULT = new ProxyCreator() {
            public <T> T getProxy(Class<T> clazz, T target) {
                return ProxyCreator.getProxy(clazz, new NotFoundHandler(target));
            }
        };
    }
}
