package ru.yandex.chemodan.app.dataapi.core.dao;

import ru.yandex.commune.db.partition.rewrite.PartitionLocator;

/**
 * @author dbrylev
 */
public class ShardPartitionLocator {
    public final int shardId;
    public final PartitionLocator partition;

    public ShardPartitionLocator(int shardId, PartitionLocator partition) {
        this.shardId = shardId;
        this.partition = partition;
    }

    public ShardPartitionLocator(int shardId, int partNum) {
        this(shardId, PartitionLocator.byDiv(partNum));
    }

    public int getPartNo() {
        return partition.getDiv();
    }

    public int getShardId() {
        return shardId;
    }
}
