package ru.yandex.chemodan.app.dataapi.core.dao;

import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.core.dao.usermeta.MetaUser;

/**
 * @author dbrylev
 */
public class UserShardInfo {
    public final DataApiUserId userId;
    public final boolean userIsInRo;
    public final int shardId;

    public UserShardInfo(DataApiUserId userId, boolean userIsInRo, int shardId) {
        this.userId = userId;
        this.userIsInRo = userIsInRo;
        this.shardId = shardId;
    }

    public UserShardId getUserShardId() {
        return new UserShardId(userId, shardId);
    }

    public static UserShardInfo fromMetaUser(MetaUser user) {
        return new UserShardInfo(user.getUserId(), user.isRo(), user.getShardId());
    }
}
