package ru.yandex.chemodan.app.dataapi.core.dao.data;

import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.data.filter.condition.CollectionIdCondition;
import ru.yandex.chemodan.app.dataapi.api.data.filter.condition.RecordCondition;
import ru.yandex.chemodan.app.dataapi.api.data.filter.condition.RecordIdCondition;
import ru.yandex.chemodan.app.dataapi.api.data.filter.ordering.RecordOrder;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecordId;
import ru.yandex.chemodan.app.dataapi.api.db.handle.DatabaseHandle;
import ru.yandex.chemodan.app.dataapi.api.db.handle.DatabaseHandleRevisions;
import ru.yandex.chemodan.app.dataapi.api.db.handle.DatabaseHandles;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRef;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.ratelimiter.chunk.ChunkRateLimiter;
import ru.yandex.commune.test.random.RunWithRandomTest;
import ru.yandex.misc.db.q.SqlCondition;
import ru.yandex.misc.db.q.SqlLimits;
import ru.yandex.misc.monica.core.name.MetricGroupName;

/**
 * @author tolmalev
 */
public interface DataRecordsJdbcDao {
    @RunWithRandomTest
    ListF<DataRecord> find(DataApiUserId uid, DatabaseHandle databaseHandle);

    @RunWithRandomTest
    ListF<DataRecord> find(
            DataApiUserId uid, DatabaseRef dbRef,
            CollectionIdCondition collectionIdCond, RecordIdCondition recordIdCond, RecordCondition dataCond,
            RecordOrder order, SqlLimits limits);

    @RunWithRandomTest
    ListF<DataRecord> find(
            DataApiUserId uid, DatabaseHandle databaseHandle,
            CollectionIdCondition collectionIdCond, RecordIdCondition recordIdCond, RecordCondition recordCond,
            RecordOrder order, SqlLimits limits);

    @RunWithRandomTest
    ListF<DataRecord> findNext(
            DataApiUserId uid, DatabaseHandle databaseHandle,
            CollectionIdCondition collectionIdCond, RecordIdCondition recordIdCond, RecordCondition recordCond,
            Option<DataRecordId> prev, int limit, boolean forceCollateC);

    @RunWithRandomTest
    ListF<DataRecord> findByDatabaseHandles(DataApiUserId uid, DatabaseHandles handles);

    int count(DataApiUserId uid, DatabaseRef dbRef, CollectionIdCondition collectionIdCond,
            RecordIdCondition recordIdCond);

    int count(DataApiUserId uid, DatabaseHandle dbHandle,
            CollectionIdCondition collectionIdCond, RecordIdCondition recordIdCond, RecordCondition recordCond);

    int count(DataApiUserId uid, SqlCondition cond);

    ListF<DataRecord> findByHandlesAndMinRevisionsOrderedByRev(
            DataApiUserId uid, DatabaseHandleRevisions minRevisions, SqlLimits limits);

    void insertBatched(DataApiUserId uid, DatabaseRef dbRef, CollectionF<DataRecord> records);

    void updateContentsWithRevisionCheck(DataApiUserId uid, DatabaseRef dbRef, DataRecord record,
            boolean migrateToJsonb);

    void updateBatched(DataApiUserId uid, CollectionF<DataRecord> records);

    void deleteRecordsBatched(DataApiUserId uid, CollectionF<DataRecordId> recordIds);

    @RunWithRandomTest
    ListF<DataRecord> findRecords(DataApiUserId uid, DatabaseHandle handle,
            CollectionF<DataRecordId> recordIds);

    @RunWithRandomTest
    void deleteAllRecordFromDatabases(DataApiUserId uid, ListF<String> handles);

    @RunWithRandomTest
    void deleteAllRecordFromDatabases(DataApiUserId uid, ListF<String> handles, ChunkRateLimiter rateLimiter);

    MetricGroupName groupName(String s);
}
