package ru.yandex.chemodan.app.dataapi.core.dao.data;

import org.junit.Before;
import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.dataapi.api.data.filter.condition.CollectionIdCondition;
import ru.yandex.chemodan.app.dataapi.api.data.filter.condition.RecordIdCondition;
import ru.yandex.chemodan.app.dataapi.api.db.ref.AppDatabaseRef;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRef;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.misc.db.q.SqlCondition;
import ru.yandex.misc.test.Assert;

/**
 * @author yashunsky
 */
public class DataRecordsJdbcDaoTest {
    private DataApiUserId uid;
    private DatabaseRef dbRef;
    private String dbHandle;
    private CollectionIdCondition collectionIdCondition;
    private RecordIdCondition recordIdCondition;

    @Before
    public void setup() {
        uid = DataApiUserId.parse("12345");
        dbRef = new AppDatabaseRef("someAppName", "someDatabaseId");
        dbHandle = "someVeryLongHandleWithAlmostRandomDigit4";
        collectionIdCondition = CollectionIdCondition.all();
        recordIdCondition = RecordIdCondition.all();
    }

    @Test
    public void plainHandleConditionTest() {
        SqlCondition handleCondition = DataRecordsJdbcDaoImpl.plainHandle(dbHandle);
        SqlCondition recordCondition = DataRecordsJdbcDaoImpl.getBasicRecordsCondition(
                uid, dbRef, handleCondition, collectionIdCondition, recordIdCondition);

        String expectedSql = "(handle = ?) AND (user_id = ?)";
        ListF<Object> expectedArgs = Cf.list("someVeryLongHandleWithAlmostRandomDigit4", "12345");

        Assert.equals(expectedSql, recordCondition.sql());
        Assert.equals(expectedArgs, recordCondition.args());
    }

    @Test
    public void handleByQueryConditionTest() {
        SqlCondition handleCondition = DataRecordsJdbcDaoImpl.handleByDbQuery(uid, dbRef);
        SqlCondition recordCondition = DataRecordsJdbcDaoImpl.getBasicRecordsCondition(
                uid, dbRef, handleCondition, collectionIdCondition, recordIdCondition);

        String expectedSql = "(handle = (SELECT handle FROM databases_% WHERE (user_id = ?) " +
                "AND (app = ?) AND (dbId = ?))) AND (user_id = ?)";
        ListF<Object> expectedArgs = Cf.list("12345", "someAppName", "someDatabaseId", "12345");

        Assert.equals(expectedSql, recordCondition.sql());
        Assert.equals(expectedArgs, recordCondition.args());
    }
}
