package ru.yandex.chemodan.app.dataapi.core.dao.data;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function0;
import ru.yandex.chemodan.app.dataapi.api.context.DatabaseContext;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRef;
import ru.yandex.chemodan.util.postgres.PgErrorUtils;

/**
 * @author dbrylev
 */
public enum DatabaseLockMode {
    NO_LOCK(""),
    FOR_UPDATE("FOR UPDATE"),
    FOR_UPDATE_NOWAIT("FOR UPDATE NOWAIT"),
    ;

    private final String sql;

    DatabaseLockMode(String sql) {
        this.sql = sql;
    }

    public String sql() {
        return sql.isEmpty() ? sql : " " + sql;
    }

    <T> T translateExceptions(DatabaseRef dbRef, Function0<T> function) {
        return translateExceptions(dbRef.dbContext(), Cf.list(dbRef.databaseId()), function);
    }

    <T> T translateExceptions(DatabaseContext dbContext, ListF<String> databaseIds, Function0<T> function) {
        if (DatabaseLockMode.FOR_UPDATE_NOWAIT == this) {
            try {
                return function.apply();

            } catch (Exception e) {
                if (PgErrorUtils.isLockObtainError(e)) {
                    throw new DatabaseLockedException("Database "
                            + databaseIds.map(id -> dbContext.toString() + "." + id).mkString(", ")
                            + " is locked for update");
                }
                throw e;
            }
        } else {
            return function.apply();
        }
    }
}
