package ru.yandex.chemodan.app.dataapi.core.dao.data;

import java.sql.ResultSet;
import java.sql.SQLException;

import org.joda.time.Instant;
import org.springframework.jdbc.core.RowMapper;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.db.Database;
import ru.yandex.chemodan.app.dataapi.api.db.DatabaseMeta;
import ru.yandex.chemodan.app.dataapi.api.db.handle.DatabaseHandle;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.misc.dataSize.DataSize;

/**
 * @author tolmalev
 */
public class DatabaseMapper implements RowMapper<Database> {

    public static final DatabaseMapper FROM_REAL = new DatabaseMapper("modification_time");
    public static final DatabaseMapper FROM_DELETED = new DatabaseMapper("delete_time");

    private final String modificationTimeColumn;

    private DatabaseMapper(String modificationTimeColumn) {
        this.modificationTimeColumn = modificationTimeColumn;
    }

    @Override
    public Database mapRow(ResultSet rs, int rowNum) throws SQLException {
        return new Database(
                DataApiUserId.parse(rs.getString("user_id")),
                DatabaseHandle.fromAppDbId(
                        Option.ofNullable(rs.getString("app")),
                        rs.getString("dbId"),
                        rs.getString("handle")),
                rs.getLong("rev"),
                new DatabaseMeta(
                        new Instant(rs.getTimestamp("creation_time")),
                        new Instant(rs.getTimestamp(modificationTimeColumn)),
                        new DataSize(rs.getLong("size")),
                        rs.getLong("records_count"),
                        Option.ofNullable(rs.getString("description"))
                )
        );
    }

}
