package ru.yandex.chemodan.app.dataapi.core.dao.data;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.context.DatabaseContext;
import ru.yandex.chemodan.app.dataapi.api.data.filter.condition.DatabaseCondition;
import ru.yandex.chemodan.app.dataapi.api.db.Database;
import ru.yandex.chemodan.app.dataapi.api.db.filter.DatabasesFilter;
import ru.yandex.chemodan.app.dataapi.api.db.handle.DatabaseHandle;
import ru.yandex.chemodan.app.dataapi.api.db.handle.DatabaseHandles;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRef;
import ru.yandex.chemodan.app.dataapi.api.deltas.cleaning.DbRevisionPojo;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.core.dao.ShardPartitionLocator;
import ru.yandex.commune.test.random.RunWithRandomTest;
import ru.yandex.misc.dataSize.DataSize;

/**
 * @author tolmalev
 */
public interface DatabasesJdbcDao {
    @RunWithRandomTest
    void insert(Database database);

    void insertBatch(DataApiUserId uid, ListF<Database> databases);

    void save(Database database);

    void save(Database database, long currentRevision);

    @RunWithRandomTest
    int findDatabasesCount(DataApiUserId uid, DatabaseContext dbContext);

    @RunWithRandomTest
    int findDatabasesCount(DataApiUserId uid);

    @RunWithRandomTest
    ListF<Database> find(DataApiUserId uid, boolean lockForUpdate);

    @RunWithRandomTest
    ListF<Database> find(DataApiUserId uid, DatabaseContext dbContext);

    @RunWithRandomTest
    Option<Database> findByHandle(DataApiUserId uid, DatabaseHandle dbHandle, DatabaseLockMode lock);

    @RunWithRandomTest
    Option<Database> find(DataApiUserId uid, DatabaseRef dbRef);

    @RunWithRandomTest
    Option<Database> find(DataApiUserId uid, DatabaseRef dbRef, DatabaseLockMode lock);

    @RunWithRandomTest
    ListF<Database> find(
            DataApiUserId uid, DatabaseContext dbContext, ListF<String> databaseIds, DatabaseLockMode lock);

    ListF<DataApiUserId> findAppUsersOrdered(
            ShardPartitionLocator shardPartition,
            DatabaseContext dbContext, Option<String> databaseId, Option<DataApiUserId> prevUid, int limit);

    ListF<Database> find(
            ShardPartitionLocator shardPartition, DatabaseRef dbRef, DatabaseCondition dbCond);

    ListF<DbRevisionPojo> findAllDatabases(
            ShardPartitionLocator shardPartition, int pageSize, Option<String> offsetHandle);

    ListF<DataApiUserId> findDatabaseUsers(
            ShardPartitionLocator shardPartition, DatabaseRef dbRef, DatabaseCondition dbCond);

    DatabaseHandles findHandles(DataApiUserId uid, DatabasesFilter filter);

    void delete(Database database);

    void delete(DataApiUserId uid, DatabaseContext dbContext, ListF<String> databaseIds);

    void updateSize(DataApiUserId uid, String handle, long rev, DataSize size);

    ListF<ShardPartitionLocator> getShardPartitions();

    int findDatabasesCount();

    ListF<Integer> getShards();

    ListF<ShardPartitionLocator> getShardPartitions(int shardId);
}
