package ru.yandex.chemodan.app.dataapi.core.dao.data;

import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

import net.jodah.failsafe.RetryPolicy;

import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.commune.dynproperties.DynamicPropertyManager;
import ru.yandex.misc.version.AppName;

/**
 * @author friendlyevil
 */
public class DatabasesJdbcDaoProperties {
    private Supplier<Boolean> checkDeletedDatabasesEnables;
    private RetryPolicy checkDeletedDatabasesRetryPolice;

    public DatabasesJdbcDaoProperties(AppName appName, DynamicPropertyManager dynamicPropertyManager) {
        DynamicProperty<Boolean> waitDeletedEnable =
                new DynamicProperty<>(appName.appName() + "-wait-deleted-database-enable", false);
        DynamicProperty<Integer> maxRetries =
                new DynamicProperty<>(appName.appName() + "-check-deleted-database-max-retries", 3);
        DynamicProperty<Long> delayMillis =
                new DynamicProperty<>(appName.appName() + "-check-deleted-database-sleep-ms", 100L);
        DynamicProperty<Long> maxDelayMillis =
                new DynamicProperty<>(appName.appName() + "-check-deleted-database-max-delay-ms", 300L);
        DynamicProperty<Double> delayMultiplier =
                new DynamicProperty<>(appName.appName() + "-check-deleted-database-sleep-delay-multiplier", 2.0);

        Supplier<RetryPolicy> retryPoliceFromDynamicProperties =
                () -> createRetryPolice(maxRetries::get, delayMillis::get, maxDelayMillis::get, delayMultiplier::get);

        dynamicPropertyManager.registerWatcher(maxRetries,
                p -> setDeletedDatabasesRetryPolice(retryPoliceFromDynamicProperties.get()));
        dynamicPropertyManager.registerWatcher(delayMillis,
                p -> setDeletedDatabasesRetryPolice(retryPoliceFromDynamicProperties.get()));
        dynamicPropertyManager.registerWatcher(maxDelayMillis,
                p -> setDeletedDatabasesRetryPolice(retryPoliceFromDynamicProperties.get()));
        dynamicPropertyManager.registerWatcher(delayMultiplier,
                p -> setDeletedDatabasesRetryPolice(retryPoliceFromDynamicProperties.get()));

        this.checkDeletedDatabasesRetryPolice = retryPoliceFromDynamicProperties.get();
        this.checkDeletedDatabasesEnables = waitDeletedEnable::get;
    }

    public RetryPolicy getCheckDeletedDatabasesRetryPolice() {
        return checkDeletedDatabasesRetryPolice;
    }

    public boolean checkDeletedDatabasesEnabled() {
        return checkDeletedDatabasesEnables.get();
    }

    public void setDeletedDatabasesRetryPolice(RetryPolicy retryPolice) {
        checkDeletedDatabasesRetryPolice = retryPolice;
    }

    // for test
    public void setCheckDeletedDatabasesEnables(Supplier<Boolean> checkDeletedDatabasesEnables) {
        this.checkDeletedDatabasesEnables = checkDeletedDatabasesEnables;
    }

    public static RetryPolicy createRetryPolice(int maxRetries, long delayMs, long maxDelayMs, double delayMultiplier) {
        return new RetryPolicy()
                .retryIf(o -> !o.equals(0))
                .withMaxRetries(maxRetries)
                .withBackoff(delayMs, maxDelayMs, TimeUnit.MILLISECONDS, delayMultiplier);
    }

    private static RetryPolicy createRetryPolice(Supplier<Integer> maxRetries, Supplier<Long> delay,
                                                 Supplier<Long> maxDelay, Supplier<Double> delayMultiplier) {
        return createRetryPolice(maxRetries.get(), delay.get(), maxDelay.get(), delayMultiplier.get());
    }
}
